/*
 * Decompiled with CFR 0.152.
 */
package me.imhermes.pxMusicAPI.songTypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.imhermes.pxMusicAPI.PxMusic;
import me.imhermes.pxMusicAPI.songTypes.Note;
import me.imhermes.pxMusicAPI.songTypes.PlayingSong;
import org.bukkit.Sound;

public abstract class Song {
    private float defaultSlownessModifier = 1.0f;
    private float defaultPitchModifier = 1.0f;
    private float defaultVolumeModifier = 1.0f;
    private final Map<Integer, List<Note>> notes = new HashMap<Integer, List<Note>>();
    private final List<Sound> stopSounds = new ArrayList<Sound>();
    private int songLength = 0;
    private boolean songLengthAutoModify = true;

    public void defaultSlownessModifier(float slownessModifier) {
        this.defaultSlownessModifier = slownessModifier;
    }

    public void defaultPitchModifier(float pitchModifier) {
        this.defaultPitchModifier = pitchModifier;
    }

    public void defaultVolumeModifier(float volumeModifier) {
        this.defaultVolumeModifier = volumeModifier;
    }

    public float defaultVolumeModifier() {
        return this.defaultVolumeModifier;
    }

    public float defaultSlownessModifier() {
        return this.defaultSlownessModifier;
    }

    public float defaultPitchModifier() {
        return this.defaultPitchModifier;
    }

    public Map<Integer, List<Note>> notes() {
        return this.notes;
    }

    public int songLength() {
        return this.songLength;
    }

    public void songLength(int length) {
        this.songLength = length;
        this.songLengthAutoModify = false;
    }

    public void addStopSound(Sound sound, int position) {
        this.stopSounds.set(position, sound);
    }

    public List<Sound> stopSounds() {
        return this.stopSounds;
    }

    public void removeStopSound(int position) {
        this.stopSounds.remove(position);
    }

    public void addNote(String sound, int position, float volume, float pitch) {
        this.addNote(position, new Note(sound, volume, pitch));
    }

    public void addNote(int position, Note note) {
        List notesAtPosition = this.notes.getOrDefault(position, new ArrayList());
        notesAtPosition.add(note);
        this.notes.put(position, notesAtPosition);
        if (this.songLengthAutoModify && this.songLength < position) {
            this.songLength = position;
        }
    }

    public PlayingSong play() {
        return PxMusic.getAPI().createPlayingSong(this);
    }

    public abstract void init();
}

